IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_SCA_IdentifIdCliente') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_SCA_IdentifIdCliente
END
GO

CREATE FUNCTION [dbo].[CF_SCA_IdentifIdCliente](@pDato VARCHAR(100))
RETURNS INT
AS
BEGIN
DECLARE @Id_Cliente					INT
DECLARE @Flag_Tipo_DNI				TINYINT
DECLARE @Flag_Formato_Valido_Doc	INT
DECLARE @Doc_Escaneado				VARCHAR(20)
DECLARE @Doc_Nro					BIGINT
DECLARE @Long_Dato					INT
DECLARE @Flag_Es_Numerico			TINYINT
DECLARE @DatoOriginal				VARCHAR(100)

IF(ISNULL(@pDato, '') = '')
BEGIN
	SET @Id_Cliente = 0
	RETURN @Id_Cliente
END

SET @Long_Dato			= LEN(@pDato)
SET @Flag_Es_Numerico	= dbo.CF_IsNumeric(@pDato)
SET @DatoOriginal		= @pDato

IF(@Long_Dato > 60)
BEGIN
	/*
	08-08-2022: Se deja los mayores de 60 digitos que se consideren como DNI Leidos ya que los QR ahora son de 10 caracteres numericos
	
	/*QR*/
	SET @Id_Cliente = ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Clientes_Links WHERE LOWER(LTRIM(RTRIM(URL)))= LOWER(LTRIM(RTRIM(@pDato)))), 0)
	RETURN @Id_Cliente
	*/
	IF(dbo.CF_xParam('QR_Dinamico') = 1)
	BEGIN
		SET @pDato = (SELECT SUBSTRING(@pDato,1,10))
		SET @Id_Cliente = ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Clientes_Links 
									WHERE Token = LOWER(LTRIM(RTRIM(@pDato))) AND FECHA_GEN > DATEADD(MINUTE, -3, GETDATE())),0)
		IF(@Id_Cliente = 0)
		BEGIN
			SET @Id_Cliente = ISNULL((SELECT dbo.CF_IdentifDNI(@DatoOriginal)),0)
			IF(@Id_Cliente = 0)
			BEGIN
				SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Credencial_Nro = UPPER(LTRIM(RTRIM(@DatoOriginal)))), 0)
			END
		END		
	END
	ELSE
	BEGIN
		SET @Id_Cliente = ISNULL((SELECT dbo.SF_IdentifDNI(@pDato)),0)
		IF(@Id_Cliente = 0)
		BEGIN
			SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Credencial_Nro = UPPER(LTRIM(RTRIM(@pDato)))), 0)
		END
	END
	
	RETURN @Id_Cliente
END

IF(@Flag_Es_Numerico = 0)
BEGIN
	/*Credencial MiFare*/
	SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Credencial_Nro = UPPER(LTRIM(RTRIM(@pDato)))), 0)
	IF(@Id_Cliente = 0)
	BEGIN
		IF(dbo.CF_xParam('QR_Dinamico') = 1)
		BEGIN
			SET @pDato = (SELECT SUBSTRING(@pDato,1,10))
			SET @Id_Cliente = ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Clientes_Links 
										WHERE Token = LOWER(LTRIM(RTRIM(@pDato))) AND FECHA_GEN > DATEADD(MINUTE, -3, GETDATE())),0)
		END
		IF(@Id_Cliente = 0)
		BEGIN
			SET @Id_Cliente = ISNULL((SELECT dbo.CF_IdentifDNI(@DatoOriginal)),0)
			IF(@Id_Cliente = 0)
			BEGIN
				SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Credencial_Nro = UPPER(LTRIM(RTRIM(@DatoOriginal)))), 0)
			END
		END	
	END
	RETURN @Id_Cliente
END

IF(@Flag_Es_Numerico = 1)
BEGIN
	/*DNI*/
	IF(CONVERT(BIGINT, @pDato) < 3000000000)
	BEGIN
		SET @Id_Cliente = ISNULL((SELECT TOP 1 Id_Cliente FROM Clientes WHERE Doc_Nro = @pDato ORDER BY Activo DESC, Id_Cliente DESC), 0)	
		RETURN @Id_Cliente
	END
	ELSE
	BEGIN
		/*QR Intelektron Numerico de 10 caracteres que empieza con 9*/
		IF(dbo.CF_xParam('QR_Dinamico') = 1)
		BEGIN
			SET @pDato = (SELECT SUBSTRING(@pDato,1,10))
			SET @Id_Cliente = ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Clientes_Links 
										WHERE Token = LOWER(LTRIM(RTRIM(@pDato))) AND FECHA_GEN > DATEADD(MINUTE, -3, GETDATE())),0)
			IF(@Id_Cliente = 0)
			BEGIN
				SET @Id_Cliente = ISNULL((SELECT dbo.CF_IdentifDNI(@DatoOriginal)),0)
				IF(@Id_Cliente = 0)
				BEGIN
					SET @Id_Cliente = ISNULL((SELECT MAX(Id_Cliente) FROM Clientes WHERE Credencial_Nro = UPPER(LTRIM(RTRIM(@DatoOriginal)))), 0)
				END
			END				
		END
		ELSE
		BEGIN
			SET @Id_Cliente = ISNULL((SELECT ISNULL(Id_Cliente, 0) FROM Clientes_Links WHERE Token = LOWER(LTRIM(RTRIM(@pDato)))), 0)
		END
		RETURN @Id_Cliente
	END
END

RETURN ISNULL(@Id_Cliente, 0)
END

--POR NRO DOC			SELECT dbo.CF_SCA_IdentifIdCliente('33554240')				RTA: 879212
--POR QR				SELECT dbo.CF_SCA_IdentifIdCliente('3475627707')			RTA: 879212
--POR DNI NUEVO			SELECT dbo.CF_SCA_IdentifIdCliente('00586082921"PAZ WERNER"FEDERICO"M"33554240"B"05-03-1988"11-03-2019"202')		RTA: 879212
--POR DNI VIEJO			SELECT dbo.CF_SCA_IdentifIdCliente('"33554240    "A"1"PAZ WERNER"FEDERICO"ARGENTINA"05-03-1988"M"18-06-2010"00013006433"7000 "18-06-2025"323"0"ILRÑ01.2 CÑ100614.02"UNIDAD ·05 ÇÇ S-NÑ 0040:2008::0005')   RTA: 879212